"use strict";
/*
  Simplified BSD License (see LICENSES/BSD-2-Clause.txt or https://opensource.org/licenses/BSD-2-Clause)
  SPDX-FileCopyrightText: Ansible Project
  SPDX-License-Identifier: BSD-2-Clause
*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPluginType = exports.isFQCN = void 0;
function isFQCN(input) {
    return input.match(/^[a-z0-9_]+\.[a-z0-9_]+(?:\.[a-z0-9_]+)+$/) !== null;
}
exports.isFQCN = isFQCN;
function isPluginType(input) {
    /* We do not want to hard-code a list of valid plugin types that might be inaccurate, so we simply check whether this is a valid kind of Python identifier usually used for plugin types. If ansible-core ever adds one with digits, we'll have to update this. */
    return /^[a-z_]+$/.test(input);
}
exports.isPluginType = isPluginType;
//# sourceMappingURL=ansible.js.map