/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.octree;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import org.gephi.visualization.model.node.NodeModel;

public class Octant {
    protected static final long ONEOVERPHI = 106039L;
    protected static final float TRIM_THRESHOLD = 1000.0f;
    protected static final float TRIM_RATIO = 0.3f;
    protected int leafId = -1;
    protected float size;
    protected float posX;
    protected float posY;
    protected float posZ;
    protected int depth;
    protected Octant[] children;
    protected int nodeCount = 0;
    protected NodeModel[] nodes;
    protected int[] nodesGarbage;
    protected int nodesGarbageLength;
    protected int nodesLength;
    protected boolean visible;

    public Octant(int depth, float posX, float posY, float posZ, float size) {
        this.size = size;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.depth = depth;
    }

    protected void addNode(NodeModel nodeModel) {
        int id;
        if (this.nodesGarbageLength > 0) {
            id = this.removeGarbage();
        } else {
            id = this.nodesLength++;
            this.growNodes(id);
        }
        this.nodes[id] = nodeModel;
        ++this.nodeCount;
        nodeModel.setOctantId(id);
    }

    protected void removeNode(NodeModel nodeModel) {
        int id = nodeModel.getOctantId();
        nodeModel.setOctantId(-1);
        this.nodes[id] = null;
        --this.nodeCount;
        this.addGarbage(id);
        this.trimNodes();
    }

    protected void clear() {
        this.nodes = null;
        this.nodesGarbage = null;
        this.nodesLength = 0;
        this.nodesGarbage = null;
        this.nodesGarbageLength = 0;
        this.nodeCount = 0;
    }

    protected boolean isEmpty() {
        return this.nodeCount == 0;
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public float getPosZ() {
        return this.posZ;
    }

    public float getSize() {
        return this.size;
    }

    protected void displayOctant(GL2 gl) {
        float quantum = this.size / 2.0f;
        gl.glBegin(8);
        gl.glVertex3f(this.posX + quantum, this.posY + quantum, this.posZ + quantum);
        gl.glVertex3f(this.posX + quantum, this.posY - quantum, this.posZ + quantum);
        gl.glVertex3f(this.posX + quantum, this.posY + quantum, this.posZ - quantum);
        gl.glVertex3f(this.posX + quantum, this.posY - quantum, this.posZ - quantum);
        gl.glVertex3f(this.posX - quantum, this.posY + quantum, this.posZ - quantum);
        gl.glVertex3f(this.posX - quantum, this.posY - quantum, this.posZ - quantum);
        gl.glVertex3f(this.posX - quantum, this.posY + quantum, this.posZ + quantum);
        gl.glVertex3f(this.posX - quantum, this.posY - quantum, this.posZ + quantum);
        gl.glVertex3f(this.posX + quantum, this.posY + quantum, this.posZ + quantum);
        gl.glVertex3f(this.posX + quantum, this.posY - quantum, this.posZ + quantum);
        gl.glEnd();
        gl.glBegin(7);
        gl.glVertex3f(this.posX - quantum, this.posY + quantum, this.posZ - quantum);
        gl.glVertex3f(this.posX - quantum, this.posY + quantum, this.posZ + quantum);
        gl.glVertex3f(this.posX + quantum, this.posY + quantum, this.posZ + quantum);
        gl.glVertex3f(this.posX + quantum, this.posY + quantum, this.posZ - quantum);
        gl.glVertex3f(this.posX - quantum, this.posY - quantum, this.posZ + quantum);
        gl.glVertex3f(this.posX - quantum, this.posY - quantum, this.posZ - quantum);
        gl.glVertex3f(this.posX + quantum, this.posY - quantum, this.posZ - quantum);
        gl.glVertex3f(this.posX + quantum, this.posY - quantum, this.posZ + quantum);
        gl.glEnd();
    }

    protected void displayOctantInfo(GL2 gl, GLU glu) {
        GLUT glut = new GLUT();
        float quantum = this.size / 2.0f;
        float height = 15.0f;
        gl.glPushMatrix();
        gl.glTranslatef(this.posX - quantum, this.posY + quantum - height, this.posZ + quantum);
        gl.glScalef(0.1f, 0.1f, 0.1f);
        gl.glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
        glut.glutStrokeString(1, "ID: " + this.leafId);
        gl.glPopMatrix();
        gl.glPushMatrix();
        gl.glTranslatef(this.posX - quantum, this.posY + quantum - (height += 15.0f), this.posZ + quantum);
        gl.glScalef(0.1f, 0.1f, 0.1f);
        gl.glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
        glut.glutStrokeString(1, "objectsCount: " + this.nodeCount);
        gl.glPopMatrix();
    }

    private void addGarbage(int index) {
        if (this.nodesGarbage == null) {
            this.nodesGarbage = new int[10];
        } else if (this.nodesGarbageLength == this.nodesGarbage.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)this.nodesGarbage.length >>> 16, (long)(this.nodesGarbageLength + 1)), Integer.MAX_VALUE);
            int[] t = new int[newLength];
            System.arraycopy(this.nodesGarbage, 0, t, 0, this.nodesGarbage.length);
            this.nodesGarbage = t;
        }
        this.nodesGarbage[this.nodesGarbageLength++] = index;
    }

    private int removeGarbage() {
        return this.nodesGarbage[--this.nodesGarbageLength];
    }

    private void growNodes(int index) {
        if (this.nodes == null) {
            this.nodes = new NodeModel[10];
        } else if (index >= this.nodes.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)this.nodes.length >>> 16, (long)(index + 1)), Integer.MAX_VALUE);
            NodeModel[] t = new NodeModel[newLength];
            System.arraycopy(this.nodes, 0, t, 0, this.nodes.length);
            this.nodes = t;
        }
    }

    private void trimNodes() {
        if ((float)this.nodesLength >= 1000.0f && (float)this.nodeCount / (float)this.nodesLength < 0.3f) {
            NodeModel[] t = new NodeModel[this.nodeCount];
            if (this.nodeCount > 0) {
                int c = 0;
                for (int i = 0; i < this.nodes.length; ++i) {
                    NodeModel n = this.nodes[i];
                    if (n == null) continue;
                    n.setOctantId(c);
                    t[c++] = n;
                }
            }
            this.nodesLength = t.length;
            this.nodes = t;
            this.nodesGarbage = null;
            this.nodesGarbageLength = 0;
        }
    }
}

