/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard.ui;

import com.intellij.java.library.MavenCoordinatesKt;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.tools.projectWizard.wizard.KotlinNewProjectWizardUIBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001c\u001d\u001eB(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u0004\u0018\u00010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005H\u0002J\u0010\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001bH\u0002R\"\u0010\u0004\u001a\u0013\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ui/StdlibVersionChooserDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "availableLibraries", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "getAvailableLibraries", "()Ljava/util/Map;", "selectedLibrary", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ui/StdlibVersionChooserDialog$LibraryNameAndVersion;", "library", "getLibrary", "()Ljava/lang/String;", "getChosenLibrary", "createCenterPanel", "Ljavax/swing/JComponent;", "getLibrariesNamesAndVersions", "", "getLibraryNamesAndEntries", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ui/StdlibVersionChooserDialog$LibraryVersionAndOrderEntry;", "createRenderer", "Ljavax/swing/ListCellRenderer;", "LibraryNameAndVersion", "LibraryVersionAndOrderEntry", "Companion", "kotlin.project-wizard.idea"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStdlibVersionChooserDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StdlibVersionChooserDialog.kt\norg/jetbrains/kotlin/tools/projectWizard/wizard/ui/StdlibVersionChooserDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,93:1\n1#2:94\n1#2:105\n1#2:118\n136#3,9:95\n216#3:104\n217#3:106\n145#3:107\n136#3,9:108\n216#3:117\n217#3:119\n145#3:120\n*S KotlinDebug\n*F\n+ 1 StdlibVersionChooserDialog.kt\norg/jetbrains/kotlin/tools/projectWizard/wizard/ui/StdlibVersionChooserDialog\n*L\n61#1:105\n69#1:118\n61#1:95,9\n61#1:104\n61#1:106\n61#1:107\n69#1:108,9\n69#1:117\n69#1:119\n69#1:120\n*E\n"})
public final class StdlibVersionChooserDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, LibraryOrderEntry> availableLibraries;
    @NotNull
    private final AtomicProperty<LibraryNameAndVersion> selectedLibrary;
    private static final int MAXIMUM_VISIBLE_LIBRARY_NAME = 40;
    private static final int SUFFIX_LENGTH = 0;
    private static final boolean USE_ELLIPSIS_SYMBOL = true;

    public StdlibVersionChooserDialog(@NotNull Project project, @NotNull Map<String, ? extends LibraryOrderEntry> availableLibraries) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(availableLibraries, (String)"availableLibraries");
        super(project);
        this.availableLibraries = availableLibraries;
        this.selectedLibrary = new AtomicProperty((Object)new LibraryNameAndVersion(null, null, 3, null));
        this.setTitle(KotlinNewProjectWizardUIBundle.message("dialog.choose.stdlib", new Object[0]));
        this.setCancelButtonText(KotlinNewProjectWizardUIBundle.message("dialog.use.default.library.button", new Object[0]));
        this.init();
    }

    @NotNull
    public final Map<String, LibraryOrderEntry> getAvailableLibraries() {
        return this.availableLibraries;
    }

    @Nullable
    public final String getLibrary() {
        Object object = this.selectedLibrary.get();
        LibraryNameAndVersion it = (LibraryNameAndVersion)object;
        boolean bl = false;
        LibraryNameAndVersion libraryNameAndVersion = (LibraryNameAndVersion)(!StringsKt.isBlank((CharSequence)it.getLibraryName()) ? object : null);
        return libraryNameAndVersion != null ? libraryNameAndVersion.getLibraryName() : null;
    }

    @Nullable
    public final LibraryOrderEntry getChosenLibrary() {
        return this.availableLibraries.get(this.getLibrary());
    }

    @NotNull
    protected JComponent createCenterPanel() {
        List<LibraryNameAndVersion> librariesNamesAndVersions = this.getLibrariesNamesAndVersions();
        LibraryNameAndVersion firstLibrary = !((Collection)librariesNamesAndVersions).isEmpty() ? (LibraryNameAndVersion)CollectionsKt.first(librariesNamesAndVersions) : new LibraryNameAndVersion(null, null, 3, null);
        this.selectedLibrary.set((Object)new LibraryNameAndVersion(firstLibrary.getLibraryName(), firstLibrary.getVersion()));
        return (JComponent)com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> StdlibVersionChooserDialog.createCenterPanel$lambda$2(librariesNamesAndVersions, this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LibraryNameAndVersion> getLibrariesNamesAndVersions() {
        void $this$mapNotNullTo$iv$iv;
        Map<String, LibraryVersionAndOrderEntry> libraryNamesAndEntries = this.getLibraryNamesAndEntries();
        Map $this$mapNotNull$iv = MapsKt.toSortedMap(libraryNamesAndEntries);
        boolean $i$f$mapNotNull = false;
        Map map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String libraryName = (String)entry.getKey();
            LibraryVersionAndOrderEntry libraryEntry = (LibraryVersionAndOrderEntry)entry.getValue();
            Intrinsics.checkNotNull((Object)libraryName);
            LibraryNameAndVersion it$iv$iv = new LibraryNameAndVersion(libraryName, libraryEntry.getLibraryVersion());
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, LibraryVersionAndOrderEntry> getLibraryNamesAndEntries() {
        void $this$mapNotNullTo$iv$iv;
        Map<String, LibraryOrderEntry> $this$mapNotNull$iv = this.availableLibraries;
        boolean $i$f$mapNotNull = false;
        Map<String, LibraryOrderEntry> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair it$iv$iv;
            String version;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String libraryName = (String)entry.getKey();
            LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entry.getValue();
            Library library = libraryEntry.getLibrary();
            String string = version = library != null && (library = MavenCoordinatesKt.getMavenCoordinates((Library)library)) != null ? library.getVersion() : null;
            if ((version == null ? null : TuplesKt.to((Object)libraryName, (Object)new LibraryVersionAndOrderEntry(version, libraryEntry))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final ListCellRenderer<LibraryNameAndVersion> createRenderer() {
        return BuilderKt.listCellRenderer((String)"", StdlibVersionChooserDialog::createRenderer$lambda$6);
    }

    private static final Unit createCenterPanel$lambda$2$lambda$1(List $librariesNamesAndVersions, StdlibVersionChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)$librariesNamesAndVersions, this$0.createRenderer()), (ObservableMutableProperty)((ObservableMutableProperty)this$0.selectedLibrary));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$2(List $librariesNamesAndVersions, StdlibVersionChooserDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(KotlinNewProjectWizardUIBundle.message("dialog.choose.stdlib.available.libs", new Object[0]), arg_0 -> StdlibVersionChooserDialog.createCenterPanel$lambda$2$lambda$1($librariesNamesAndVersions, this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createRenderer$lambda$6$lambda$5(LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        $this$text.setAlign(LcrInitParams.Align.LEFT);
        return Unit.INSTANCE;
    }

    private static final Unit createRenderer$lambda$6(LcrRow $this$listCellRenderer) {
        Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
        String string = StringUtil.shortenTextWithEllipsis((String)((LibraryNameAndVersion)$this$listCellRenderer.getValue()).getLibraryName(), (int)40, (int)0, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        String libraryName = string;
        $this$listCellRenderer.text(libraryName, StdlibVersionChooserDialog::createRenderer$lambda$6$lambda$5);
        LcrRow.text$default((LcrRow)$this$listCellRenderer, (String)((LibraryNameAndVersion)$this$listCellRenderer.getValue()).getVersion(), null, (int)2, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ui/StdlibVersionChooserDialog$Companion;", "", "<init>", "()V", "MAXIMUM_VISIBLE_LIBRARY_NAME", "", "SUFFIX_LENGTH", "USE_ELLIPSIS_SYMBOL", "", "kotlin.project-wizard.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ui/StdlibVersionChooserDialog$LibraryNameAndVersion;", "", "libraryName", "", "version", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getLibraryName", "()Ljava/lang/String;", "getVersion", "kotlin.project-wizard.idea"})
    private static final class LibraryNameAndVersion {
        @NotNull
        private final String libraryName;
        @NotNull
        private final String version;

        public LibraryNameAndVersion(@Nls @NotNull String libraryName, @Nls @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.libraryName = libraryName;
            this.version = version;
        }

        public /* synthetic */ LibraryNameAndVersion(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(string, string2);
        }

        @NotNull
        public final String getLibraryName() {
            return this.libraryName;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        public LibraryNameAndVersion() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ui/StdlibVersionChooserDialog$LibraryVersionAndOrderEntry;", "", "libraryVersion", "", "library", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/roots/LibraryOrderEntry;)V", "getLibraryVersion", "()Ljava/lang/String;", "getLibrary", "()Lcom/intellij/openapi/roots/LibraryOrderEntry;", "kotlin.project-wizard.idea"})
    public static final class LibraryVersionAndOrderEntry {
        @NotNull
        private final String libraryVersion;
        @NotNull
        private final LibraryOrderEntry library;

        public LibraryVersionAndOrderEntry(@Nls @NotNull String libraryVersion, @NotNull LibraryOrderEntry library) {
            Intrinsics.checkNotNullParameter((Object)libraryVersion, (String)"libraryVersion");
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            this.libraryVersion = libraryVersion;
            this.library = library;
        }

        @NotNull
        public final String getLibraryVersion() {
            return this.libraryVersion;
        }

        @NotNull
        public final LibraryOrderEntry getLibrary() {
            return this.library;
        }
    }
}

