/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.tracker;

import java.util.Arrays;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.internal.util.collections.ArrayHelper;

public final class SimpleFieldTracker
implements DirtyTracker {
    private String[] names = ArrayHelper.EMPTY_STRING_ARRAY;
    private boolean suspended;

    @Override
    public void add(String name) {
        if (this.suspended) {
            return;
        }
        if (!this.contains(name)) {
            this.names = Arrays.copyOf(this.names, this.names.length + 1);
            this.names[this.names.length - 1] = name;
        }
    }

    @Override
    public boolean contains(String name) {
        for (String existing : this.names) {
            if (!existing.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.names = ArrayHelper.EMPTY_STRING_ARRAY;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.names.length == 0;
    }

    @Override
    public String[] get() {
        return this.names;
    }

    @Override
    public void suspend(boolean suspend) {
        this.suspended = suspend;
    }
}

