/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;

public abstract class AbstractPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    @Override
    public final byte[] recoverSessionData(PublicKeyEncSessionPacket pkesk, InputStreamPacket encData) throws PGPException {
        byte[] sessionData = this.recoverSessionData(pkesk.getAlgorithm(), pkesk.getEncSessionKey(), pkesk.getVersion());
        return this.prependSKAlgorithmToSessionData(pkesk, encData, sessionData);
    }

    @Override
    public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
        return this.recoverSessionData(keyAlgorithm, secKeyData, 3);
    }

    protected byte[] prependSKAlgorithmToSessionData(PublicKeyEncSessionPacket pkesk, InputStreamPacket encData, byte[] decryptedSessionData) throws PGPException {
        if (!this.containsSKAlg(pkesk.getVersion())) {
            if (!(encData instanceof SymmetricEncIntegrityPacket) || ((SymmetricEncIntegrityPacket)encData).getVersion() != 2) {
                throw new PGPException("v6 PKESK packet MUST precede v2 SEIPD packet");
            }
            SymmetricEncIntegrityPacket seipd2 = (SymmetricEncIntegrityPacket)encData;
            return Arrays.prepend((byte[])decryptedSessionData, (byte)((byte)(seipd2.getCipherAlgorithm() & 0xFF)));
        }
        switch (pkesk.getAlgorithm()) {
            case 25: {
                return Arrays.prepend((byte[])decryptedSessionData, (byte)pkesk.getEncSessionKey()[0][33]);
            }
            case 26: {
                return Arrays.prepend((byte[])decryptedSessionData, (byte)pkesk.getEncSessionKey()[0][57]);
            }
        }
        return decryptedSessionData;
    }

    protected boolean containsSKAlg(int pkeskVersion) {
        return pkeskVersion != 6;
    }

    protected static void checkRange(int pLen, byte[] enc) throws PGPException {
        if (pLen > enc.length) {
            throw new PGPException("encoded length out of range");
        }
    }
}

