/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.action.start;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ui.action.start.AltStartupAction;
import org.slf4j.LoggerFactory;

public class ResetPreferencesAction
extends AltStartupAction {
    @Override
    public void initialise() throws Exception {
    }

    @Override
    public void dispose() throws Exception {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            JTextPane pane = new JTextPane();
            pane.setPreferredSize(new Dimension(400, 400));
            pane.setEditable(false);
            URL u = this.getClass().getResource("ResetPreferencesExplanation.html");
            pane.setPage(u);
            Font font = UIManager.getFont("TextArea.font");
            if (font != null) {
                String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: 12pt; }";
                ((HTMLDocument)pane.getDocument()).getStyleSheet().addRule(bodyRule);
            }
            JScrollPane scroller = new JScrollPane();
            scroller.getViewport().add(pane);
            int ret = JOptionPane.showConfirmDialog(this.getParent(), scroller, "Reset Preferences?", 0, 3);
            if (ret == 0) {
                Preferences p = Preferences.userRoot();
                Preferences q = p.node("PROTEGE_PREFERENCES");
                q.removeNode();
                p.sync();
                p.flush();
                q.flush();
                JOptionPane.showMessageDialog(this.getParent(), "Preferences Reset");
                ProtegeApplication.handleQuit();
            }
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(ResetPreferencesAction.class).error("An error occurred whilst resetting the preferences: {}", (Throwable)ex);
        }
    }
}

