/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.languagetool.UserConfig;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;

public class DictionaryMatchFilter
implements RuleMatchFilter {
    private final UserConfig userConfig;

    public DictionaryMatchFilter(UserConfig userConfig) {
        this.userConfig = userConfig;
    }

    @Override
    public List<RuleMatch> filter(List<RuleMatch> ruleMatches, AnnotatedText text) {
        HashSet<String> dictionary = new HashSet<String>(this.userConfig.getAcceptedWords());
        return ruleMatches.stream().filter((? super T match) -> {
            String covered = text.getTextWithMarkup().substring(match.getFromPos(), match.getToPos());
            return !dictionary.contains(covered);
        }).collect(Collectors.toList());
    }
}

