/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;

public abstract class ArrayBuilder<T>
implements Serializable,
ReusableBuilder<T, Object> {
    private int capacity = 0;
    private int size = 0;

    /*
     * WARNING - void declaration
     */
    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        void var2_2;
        void var1_1;
        Builder.sizeHint$(this, (IterableOnce)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <NewTo> Builder<T, NewTo> mapResult(Function1<Object, NewTo> f) {
        void var1_1;
        return Builder.mapResult$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Growable<T> $plus$eq(T elem) {
        void var1_1;
        return Growable.$plus$eq$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Growable<T> $plus$plus$eq(IterableOnce<T> elems) {
        void var1_1;
        return Growable.$plus$plus$eq$(this, (IterableOnce)var1_1);
    }

    public int capacity() {
        return this.capacity;
    }

    /*
     * WARNING - void declaration
     */
    public void capacity_$eq(int x$1) {
        void var1_1;
        this.capacity = var1_1;
    }

    public abstract Object elems();

    public int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public void size_$eq(int x$1) {
        void var1_1;
        this.size = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureSize(int size) {
        int newLen = ArrayBuffer$.MODULE$.resizeUp(this.capacity(), size);
        if (newLen > 0) {
            void var1_1;
            this.resize((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void sizeHint(int size) {
        if (this.capacity() < size) {
            void var1_1;
            this.resize((int)var1_1);
            return;
        }
    }

    @Override
    public void clear() {
        this.size_$eq(0);
    }

    public abstract void resize(int var1);

    /*
     * WARNING - void declaration
     */
    public ArrayBuilder<T> addAll(Object xs) {
        void var1_1;
        return this.addAll(xs, 0, Array.getLength(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ArrayBuilder<T> addAll(Object xs, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        int offset1 = Math.max(offset, 0);
        int length1 = Math.max(length, 0);
        int min$extension_that = Array.getLength(xs) - offset1;
        int effectiveLength = Math.min(length1, min$extension_that);
        return this.doAddAll(var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayBuilder<T> doAddAll(Object xs, int offset, int length) {
        if (length > 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            ArrayBuilder arrayBuilder = this;
            arrayBuilder.ensureSize(arrayBuilder.size() + length);
            Array$.MODULE$.copy(var1_1, (int)var2_2, this.elems(), this.size(), length);
            ArrayBuilder arrayBuilder2 = this;
            arrayBuilder2.size_$eq(arrayBuilder2.size() + var3_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayBuilder<T> addAll(IterableOnce<T> xs) {
        void var2_3;
        int k = xs.knownSize();
        if (k > 0) {
            void var3_5;
            void copyElemsToArray_start;
            ArrayBuilder arrayBuilder = this;
            arrayBuilder.ensureSize(arrayBuilder.size() + k);
            int n = this.size();
            Object copyElemsToArray_xs = this.elems();
            int actual = xs instanceof Iterable ? ((Iterable)xs).copyToArray(copyElemsToArray_xs, (int)copyElemsToArray_start, Integer.MAX_VALUE) : xs.iterator().copyToArray(var3_5, (int)copyElemsToArray_start, Integer.MAX_VALUE);
            if (actual != k) {
                void var1_2;
                throw new IllegalStateException(new StringBuilder(11).append("Copied ").append((int)var1_2).append(" of ").append(k).toString());
            }
            ArrayBuilder arrayBuilder2 = this;
            arrayBuilder2.size_$eq(arrayBuilder2.size() + k);
        } else if (var2_3 < 0) {
            void var1_1;
            Growable.addAll$(this, (IterableOnce)var1_1);
        }
        return this;
    }

    public static class ofBoolean
    extends ArrayBuilder<Object> {
        private boolean[] elems;

        public boolean[] elems() {
            return this.elems;
        }

        /*
         * WARNING - void declaration
         */
        public void elems_$eq(boolean[] x$1) {
            void var1_1;
            this.elems = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private boolean[] mkArray(int size) {
            void var1_2;
            boolean[] newelems = new boolean[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void resize(int size) {
            void var1_1;
            ofBoolean ofBoolean2 = this;
            ofBoolean2.elems_$eq(ofBoolean2.mkArray(size));
            this.capacity_$eq((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public ofBoolean addOne(boolean elem) {
            void var1_1;
            ofBoolean ofBoolean2 = this;
            ofBoolean2.ensureSize(ofBoolean2.size() + 1);
            this.elems()[this.size()] = var1_1;
            ofBoolean ofBoolean3 = this;
            ofBoolean3.size_$eq(ofBoolean3.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                boolean[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            ofBoolean ofBoolean2 = this;
            return ofBoolean2.mkArray(ofBoolean2.size());
        }

        public boolean equals(Object other) {
            if (other instanceof ofBoolean) {
                ofBoolean ofBoolean2;
                ofBoolean2 = ofBoolean2;
                return this.size() == ofBoolean2.size() && this.elems() == ofBoolean2.elems();
            }
            return false;
        }

        public String toString() {
            return "ArrayBuilder.ofBoolean";
        }
    }

    public static final class ofByte
    extends ArrayBuilder<Object> {
        private byte[] elems;

        public final byte[] elems() {
            return this.elems;
        }

        /*
         * WARNING - void declaration
         */
        public final void elems_$eq(byte[] x$1) {
            void var1_1;
            this.elems = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private byte[] mkArray(int size) {
            void var1_2;
            byte[] newelems = new byte[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void resize(int size) {
            void var1_1;
            ofByte ofByte2 = this;
            ofByte2.elems_$eq(ofByte2.mkArray(size));
            this.capacity_$eq((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ofByte addOne(byte elem) {
            void var1_1;
            ofByte ofByte2 = this;
            ofByte2.ensureSize(ofByte2.size() + 1);
            this.elems()[this.size()] = var1_1;
            ofByte ofByte3 = this;
            ofByte3.size_$eq(ofByte3.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                byte[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            ofByte ofByte2 = this;
            return ofByte2.mkArray(ofByte2.size());
        }

        public final boolean equals(Object other) {
            if (other instanceof ofByte) {
                ofByte ofByte2;
                ofByte2 = ofByte2;
                return this.size() == ofByte2.size() && this.elems() == ofByte2.elems();
            }
            return false;
        }

        public final String toString() {
            return "ArrayBuilder.ofByte";
        }
    }

    public static final class ofChar
    extends ArrayBuilder<Object> {
        private char[] elems;

        public final char[] elems() {
            return this.elems;
        }

        /*
         * WARNING - void declaration
         */
        public final void elems_$eq(char[] x$1) {
            void var1_1;
            this.elems = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private char[] mkArray(int size) {
            void var1_2;
            char[] newelems = new char[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void resize(int size) {
            void var1_1;
            ofChar ofChar2 = this;
            ofChar2.elems_$eq(ofChar2.mkArray(size));
            this.capacity_$eq((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ofChar addOne(char elem) {
            void var1_1;
            ofChar ofChar2 = this;
            ofChar2.ensureSize(ofChar2.size() + 1);
            this.elems()[this.size()] = var1_1;
            ofChar ofChar3 = this;
            ofChar3.size_$eq(ofChar3.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final char[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                char[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            ofChar ofChar2 = this;
            return ofChar2.mkArray(ofChar2.size());
        }

        public final boolean equals(Object other) {
            if (other instanceof ofChar) {
                ofChar ofChar2;
                ofChar2 = ofChar2;
                return this.size() == ofChar2.size() && this.elems() == ofChar2.elems();
            }
            return false;
        }

        public final String toString() {
            return "ArrayBuilder.ofChar";
        }
    }

    public static final class ofDouble
    extends ArrayBuilder<Object> {
        private double[] elems;

        public final double[] elems() {
            return this.elems;
        }

        /*
         * WARNING - void declaration
         */
        public final void elems_$eq(double[] x$1) {
            void var1_1;
            this.elems = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private double[] mkArray(int size) {
            void var1_2;
            double[] newelems = new double[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void resize(int size) {
            void var1_1;
            ofDouble ofDouble2 = this;
            ofDouble2.elems_$eq(ofDouble2.mkArray(size));
            this.capacity_$eq((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ofDouble addOne(double elem) {
            void var1_1;
            ofDouble ofDouble2 = this;
            ofDouble2.ensureSize(ofDouble2.size() + 1);
            this.elems()[this.size()] = var1_1;
            ofDouble ofDouble3 = this;
            ofDouble3.size_$eq(ofDouble3.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                double[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            ofDouble ofDouble2 = this;
            return ofDouble2.mkArray(ofDouble2.size());
        }

        public final boolean equals(Object other) {
            if (other instanceof ofDouble) {
                ofDouble ofDouble2;
                ofDouble2 = ofDouble2;
                return this.size() == ofDouble2.size() && this.elems() == ofDouble2.elems();
            }
            return false;
        }

        public final String toString() {
            return "ArrayBuilder.ofDouble";
        }
    }

    public static final class ofFloat
    extends ArrayBuilder<Object> {
        private float[] elems;

        public final float[] elems() {
            return this.elems;
        }

        /*
         * WARNING - void declaration
         */
        public final void elems_$eq(float[] x$1) {
            void var1_1;
            this.elems = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private float[] mkArray(int size) {
            void var1_2;
            float[] newelems = new float[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void resize(int size) {
            void var1_1;
            ofFloat ofFloat2 = this;
            ofFloat2.elems_$eq(ofFloat2.mkArray(size));
            this.capacity_$eq((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ofFloat addOne(float elem) {
            void var1_1;
            ofFloat ofFloat2 = this;
            ofFloat2.ensureSize(ofFloat2.size() + 1);
            this.elems()[this.size()] = var1_1;
            ofFloat ofFloat3 = this;
            ofFloat3.size_$eq(ofFloat3.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final float[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                float[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            ofFloat ofFloat2 = this;
            return ofFloat2.mkArray(ofFloat2.size());
        }

        public final boolean equals(Object other) {
            if (other instanceof ofFloat) {
                ofFloat ofFloat2;
                ofFloat2 = ofFloat2;
                return this.size() == ofFloat2.size() && this.elems() == ofFloat2.elems();
            }
            return false;
        }

        public final String toString() {
            return "ArrayBuilder.ofFloat";
        }
    }

    public static final class ofInt
    extends ArrayBuilder<Object> {
        private int[] elems;

        public final int[] elems() {
            return this.elems;
        }

        /*
         * WARNING - void declaration
         */
        public final void elems_$eq(int[] x$1) {
            void var1_1;
            this.elems = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private int[] mkArray(int size) {
            void var1_2;
            int[] newelems = new int[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void resize(int size) {
            void var1_1;
            ofInt ofInt2 = this;
            ofInt2.elems_$eq(ofInt2.mkArray(size));
            this.capacity_$eq((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ofInt addOne(int elem) {
            void var1_1;
            ofInt ofInt2 = this;
            ofInt2.ensureSize(ofInt2.size() + 1);
            this.elems()[this.size()] = var1_1;
            ofInt ofInt3 = this;
            ofInt3.size_$eq(ofInt3.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                int[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            ofInt ofInt2 = this;
            return ofInt2.mkArray(ofInt2.size());
        }

        public final boolean equals(Object other) {
            if (other instanceof ofInt) {
                ofInt ofInt2;
                ofInt2 = ofInt2;
                return this.size() == ofInt2.size() && this.elems() == ofInt2.elems();
            }
            return false;
        }

        public final String toString() {
            return "ArrayBuilder.ofInt";
        }
    }

    public static final class ofLong
    extends ArrayBuilder<Object> {
        private long[] elems;

        public final long[] elems() {
            return this.elems;
        }

        /*
         * WARNING - void declaration
         */
        public final void elems_$eq(long[] x$1) {
            void var1_1;
            this.elems = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private long[] mkArray(int size) {
            void var1_2;
            long[] newelems = new long[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void resize(int size) {
            void var1_1;
            ofLong ofLong2 = this;
            ofLong2.elems_$eq(ofLong2.mkArray(size));
            this.capacity_$eq((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ofLong addOne(long elem) {
            void var1_1;
            ofLong ofLong2 = this;
            ofLong2.ensureSize(ofLong2.size() + 1);
            this.elems()[this.size()] = var1_1;
            ofLong ofLong3 = this;
            ofLong3.size_$eq(ofLong3.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                long[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            ofLong ofLong2 = this;
            return ofLong2.mkArray(ofLong2.size());
        }

        public final boolean equals(Object other) {
            if (other instanceof ofLong) {
                ofLong ofLong2;
                ofLong2 = ofLong2;
                return this.size() == ofLong2.size() && this.elems() == ofLong2.elems();
            }
            return false;
        }

        public final String toString() {
            return "ArrayBuilder.ofLong";
        }
    }

    public static final class ofRef<T>
    extends ArrayBuilder<T> {
        private final ClassTag<T> ct;
        private T[] elems;

        public final T[] elems() {
            return this.elems;
        }

        /*
         * WARNING - void declaration
         */
        public final void elems_$eq(T[] x$1) {
            void var1_1;
            this.elems = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private T[] mkArray(int size) {
            void var1_1;
            if (this.capacity() == size && this.capacity() > 0) {
                return this.elems();
            }
            if (this.elems() == null) {
                return (Object[])this.ct.newArray(size);
            }
            return Arrays.copyOf(this.elems(), (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void resize(int size) {
            void var1_1;
            ofRef ofRef2 = this;
            ofRef2.elems_$eq(ofRef2.mkArray(size));
            this.capacity_$eq((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ofRef<T> addOne(T elem) {
            void var1_1;
            ofRef ofRef2 = this;
            ofRef2.ensureSize(ofRef2.size() + 1);
            this.elems()[this.size()] = var1_1;
            ofRef ofRef3 = this;
            ofRef3.size_$eq(ofRef3.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                T[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            ofRef ofRef2 = this;
            return ofRef2.mkArray(ofRef2.size());
        }

        @Override
        public final void clear() {
            super.clear();
            if (this.elems() != null) {
                Arrays.fill(this.elems(), null);
                return;
            }
        }

        public final boolean equals(Object other) {
            if (other instanceof ofRef) {
                ofRef ofRef2;
                ofRef2 = ofRef2;
                return this.size() == ofRef2.size() && this.elems() == ofRef2.elems();
            }
            return false;
        }

        public final String toString() {
            return "ArrayBuilder.ofRef";
        }

        /*
         * WARNING - void declaration
         */
        public ofRef(ClassTag<T> ct) {
            void var1_1;
            this.ct = var1_1;
        }
    }

    public static final class ofShort
    extends ArrayBuilder<Object> {
        private short[] elems;

        public final short[] elems() {
            return this.elems;
        }

        /*
         * WARNING - void declaration
         */
        public final void elems_$eq(short[] x$1) {
            void var1_1;
            this.elems = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private short[] mkArray(int size) {
            void var1_2;
            short[] newelems = new short[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void resize(int size) {
            void var1_1;
            ofShort ofShort2 = this;
            ofShort2.elems_$eq(ofShort2.mkArray(size));
            this.capacity_$eq((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ofShort addOne(short elem) {
            void var1_1;
            ofShort ofShort2 = this;
            ofShort2.ensureSize(ofShort2.size() + 1);
            this.elems()[this.size()] = var1_1;
            ofShort ofShort3 = this;
            ofShort3.size_$eq(ofShort3.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final short[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                short[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            ofShort ofShort2 = this;
            return ofShort2.mkArray(ofShort2.size());
        }

        public final boolean equals(Object other) {
            if (other instanceof ofShort) {
                ofShort ofShort2;
                ofShort2 = ofShort2;
                return this.size() == ofShort2.size() && this.elems() == ofShort2.elems();
            }
            return false;
        }

        public final String toString() {
            return "ArrayBuilder.ofShort";
        }
    }

    public static final class ofUnit
    extends ArrayBuilder<BoxedUnit> {
        public final BoxedUnit[] elems() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        public final ofUnit addOne(BoxedUnit elem) {
            void var1_2;
            int newSize = this.size() + 1;
            this.ensureSize(newSize);
            this.size_$eq((int)var1_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final ofUnit addAll(IterableOnce<BoxedUnit> xs) {
            void var1_2;
            int newSize = this.size() + xs.iterator().size();
            this.ensureSize(newSize);
            this.size_$eq((int)var1_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final ofUnit addAll(Object xs, int offset, int length) {
            void var1_2;
            void var3_4;
            int newSize = this.size() + var3_4;
            this.ensureSize(newSize);
            this.size_$eq((int)var1_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final BoxedUnit[] result() {
            void var1_1;
            BoxedUnit[] ans = new BoxedUnit[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                ans[i] = BoxedUnit.UNIT;
            }
            return var1_1;
        }

        public final boolean equals(Object other) {
            if (other instanceof ofUnit) {
                ofUnit ofUnit2;
                ofUnit2 = ofUnit2;
                return this.size() == ofUnit2.size();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void resize(int size) {
            void var1_1;
            this.capacity_$eq((int)var1_1);
        }

        public final String toString() {
            return "ArrayBuilder.ofUnit";
        }
    }
}

