/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.bytecode;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;

public final class BytecodeSupport {
    private BytecodeSupport() {
    }

    public static final class ConstantsBuffer {
        private static final int HASH_THRESHOLD = 8;
        private static final int EMPTY = -1;
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private static final int INITIAL_CAPACITY = 32;
        private static final int MAX_CAPACITY = 512;
        private Object[] constants;
        private int size;
        private Object[] keys;
        private int[] values;
        private int maxSize;

        public ConstantsBuffer() {
            this.initialize(32);
        }

        private void initialize(int capacity) {
            assert (this.size == 0);
            this.constants = new Object[capacity];
            this.initializeMap(capacity);
        }

        private void initializeMap(int capacity) {
            this.keys = new Object[capacity];
            this.values = ConstantsBuffer.initIntArray(capacity, -1);
        }

        public int add(Object c) {
            Objects.requireNonNull(c);
            int s = this.size;
            int result = this.fastAdd(c, s);
            if (result != -1) {
                return result;
            }
            result = this.mapGet(c);
            if (result != -1) {
                return result;
            }
            Object[] consts = this.constants;
            if (s >= consts.length) {
                consts = this.constants = Arrays.copyOf(consts, consts.length * 2);
            }
            result = this.size++;
            consts[result] = c;
            this.mapPut(c, result);
            return result;
        }

        public int addNull() {
            int index;
            Object[] consts = this.constants;
            if ((index = this.size++) >= consts.length) {
                this.constants = Arrays.copyOf(consts, consts.length * 2);
            }
            if (index == 8) {
                this.fillMapFromConsts();
            }
            return index;
        }

        public Object[] materialize() {
            if (this.size == 0) {
                return EMPTY_ARRAY;
            }
            int s = this.size;
            Object[] array = Arrays.copyOf(this.constants, s);
            this.maxSize = Math.max(s, this.maxSize);
            if (s >= 8) {
                Arrays.fill(this.keys, null);
                Arrays.fill(this.values, -1);
            }
            this.size = 0;
            return array;
        }

        public Object[] create() {
            if (this.size == 0) {
                return EMPTY_ARRAY;
            }
            return Arrays.copyOf(this.constants, this.size);
        }

        public void clear() {
            if (this.size != 0) {
                throw new IllegalStateException("Cannot clear if it was not materialized first.");
            }
            if (this.maxSize > 512) {
                this.initialize(512);
            } else {
                Arrays.fill(this.constants, 0, this.maxSize, null);
            }
            this.maxSize = 0;
        }

        private int fastAdd(Object c, int s) {
            if (s >= 8) {
                return -1;
            }
            Object[] consts = this.constants;
            assert (consts.length >= 8);
            for (int i = 0; i < s; ++i) {
                Object d = consts[i];
                if (d == null || d != c && !d.equals(c)) continue;
                return i;
            }
            if (s < 7) {
                int index = this.size++;
                consts[index] = c;
                return index;
            }
            this.fillMapFromConsts();
            return -1;
        }

        private void fillMapFromConsts() {
            Object[] consts = this.constants;
            for (int i = 0; i < this.size; ++i) {
                Object c = consts[i];
                if (c == null) continue;
                this.mapPut(c, i);
            }
        }

        private int mapGet(Object key) {
            int mask = this.keys.length - 1;
            int i = ConstantsBuffer.hash(key) & mask;
            int v;
            while ((v = this.values[i]) != -1) {
                if (this.keys[i].equals(key)) {
                    return v;
                }
                i = i + 1 & mask;
            }
            return -1;
        }

        private void mapPut(Object key, int value) {
            int mapSize = this.keys.length;
            int s = this.size;
            if (mapSize < s + (s >> 1)) {
                this.rehash(this.keys.length << 1);
                mapSize = this.keys.length;
            }
            int mask = mapSize - 1;
            int i = ConstantsBuffer.hash(key) & mask;
            while (this.values[i] != -1) {
                i = i + 1 & mask;
            }
            this.keys[i] = key;
            this.values[i] = value;
        }

        private void rehash(int newCap) {
            this.initializeMap(newCap);
            this.fillMapFromConsts();
        }

        private static int hash(Object o) {
            int h = o.hashCode();
            return h ^ h >>> 16;
        }

        private static int[] initIntArray(int n, int val) {
            int[] a = new int[n];
            Arrays.fill(a, val);
            return a;
        }
    }

    public static final class CloneReferenceList<T> {
        private WeakReference<T>[] references = new WeakReference[4];
        private int size;

        public void add(T reference) {
            if (this.size >= this.references.length) {
                this.resize();
            }
            this.references[this.size++] = new WeakReference<T>(reference);
        }

        private void resize() {
            this.cleanup();
            if (this.size >= this.references.length) {
                this.references = Arrays.copyOf(this.references, this.references.length * 2);
            }
        }

        public void forEach(Consumer<T> forEach) {
            boolean needsCleanup = false;
            for (int index = 0; index < this.size; ++index) {
                Object ref = this.references[index].get();
                if (ref != null) {
                    forEach.accept(ref);
                    continue;
                }
                needsCleanup = true;
            }
            if (needsCleanup) {
                this.cleanup();
            }
        }

        private void cleanup() {
            Object[] refs = this.references;
            int newIndex = 0;
            int oldSize = this.size;
            for (int oldIndex = 0; oldIndex < oldSize; ++oldIndex) {
                WeakReference<T> ref = refs[oldIndex];
                Object referent = ref.get();
                if (referent == null) continue;
                if (newIndex != oldIndex) {
                    refs[newIndex] = ref;
                }
                ++newIndex;
            }
            Arrays.fill(refs, newIndex, oldSize, null);
            this.size = newIndex;
        }
    }
}

