/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.SecureStorageManager;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SecureStorageWindowsManager
implements SecureStorageManager {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SecureStorageWindowsManager.class);
    private final Advapi32Lib advapi32Lib = Advapi32LibManager.getInstance();

    private SecureStorageWindowsManager() {
    }

    public static SecureStorageWindowsManager builder() {
        logger.debug("Using Windows Credential Manager as a token cache storage", new Object[0]);
        return new SecureStorageWindowsManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureStorageManager.SecureStorageStatus setCredential(String host, String user, String type, String token) {
        if (SnowflakeUtil.isNullOrEmpty(token)) {
            logger.warn("No token provided", false);
            return SecureStorageManager.SecureStorageStatus.SUCCESS;
        }
        byte[] credBlob = token.getBytes(StandardCharsets.UTF_16LE);
        Memory credBlobMem = new Memory((long)credBlob.length);
        credBlobMem.write(0L, credBlob, 0, credBlob.length);
        String target = SecureStorageManager.buildCredentialsKey(host, user, type);
        SecureStorageWindowsCredential cred = new SecureStorageWindowsCredential();
        cred.Type = SecureStorageWindowsCredentialType.CRED_TYPE_GENERIC.getType();
        cred.TargetName = new WString(target);
        cred.CredentialBlobSize = (int)credBlobMem.size();
        cred.CredentialBlob = credBlobMem;
        cred.Persist = SecureStorageWindowsCredentialPersistType.CRED_PERSIST_LOCAL_MACHINE.getType();
        cred.UserName = new WString(user.toUpperCase());
        boolean ret = false;
        Advapi32Lib advapi32Lib = this.advapi32Lib;
        synchronized (advapi32Lib) {
            ret = this.advapi32Lib.CredWriteW(cred, 0);
        }
        if (!ret) {
            logger.warn(String.format("Failed to write to Windows Credential Manager. Error code = %d", Native.getLastError()), new Object[0]);
            return SecureStorageManager.SecureStorageStatus.FAILURE;
        }
        logger.debug("Wrote to Windows Credential Manager successfully", false);
        return SecureStorageManager.SecureStorageStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCredential(String host, String user, String type) {
        PointerByReference pCredential = new PointerByReference();
        String target = SecureStorageManager.buildCredentialsKey(host, user, type);
        try {
            boolean ret = false;
            Advapi32Lib advapi32Lib = this.advapi32Lib;
            synchronized (advapi32Lib) {
                ret = this.advapi32Lib.CredReadW(target, SecureStorageWindowsCredentialType.CRED_TYPE_GENERIC.getType(), 0, pCredential);
            }
            if (!ret) {
                logger.warn(String.format("Failed to read target or could not find it in Windows Credential Manager. Error code = %d", Native.getLastError()), new Object[0]);
                advapi32Lib = null;
                return advapi32Lib;
            }
            logger.debug("Found the token from Windows Credential Manager and now copying it", false);
            SecureStorageWindowsCredential cred = new SecureStorageWindowsCredential(pCredential.getValue());
            if (SecureStorageWindowsCredentialType.typeOf(cred.Type) != SecureStorageWindowsCredentialType.CRED_TYPE_GENERIC) {
                logger.warn("Wrong type of credential. Expected: CRED_TYPE_GENERIC", false);
                String string = null;
                return string;
            }
            if (cred.CredentialBlobSize == 0) {
                logger.debug("Returned credential is empty", false);
                String string = null;
                return string;
            }
            byte[] credBytes = cred.CredentialBlob.getByteArray(0L, cred.CredentialBlobSize);
            String res = new String(credBytes, StandardCharsets.UTF_16LE);
            logger.debug("Successfully read the token. Will return it as String now", false);
            String string = res;
            return string;
        }
        finally {
            if (pCredential.getValue() != null) {
                Advapi32Lib advapi32Lib = this.advapi32Lib;
                synchronized (advapi32Lib) {
                    this.advapi32Lib.CredFree(pCredential.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureStorageManager.SecureStorageStatus deleteCredential(String host, String user, String type) {
        String target = SecureStorageManager.buildCredentialsKey(host, user, type);
        boolean ret = false;
        Advapi32Lib advapi32Lib = this.advapi32Lib;
        synchronized (advapi32Lib) {
            ret = this.advapi32Lib.CredDeleteW(target, SecureStorageWindowsCredentialType.CRED_TYPE_GENERIC.getType(), 0);
        }
        if (!ret) {
            logger.warn(String.format("Failed to delete target in Windows Credential Manager. Error code = %d", Native.getLastError()), new Object[0]);
            return SecureStorageManager.SecureStorageStatus.FAILURE;
        }
        logger.debug("Deleted target in Windows Credential Manager successfully", false);
        return SecureStorageManager.SecureStorageStatus.SUCCESS;
    }

    static interface Advapi32Lib
    extends StdCallLibrary {
        public boolean CredReadW(String var1, int var2, int var3, PointerByReference var4);

        public boolean CredWriteW(SecureStorageWindowsCredential var1, int var2);

        public boolean CredDeleteW(String var1, int var2, int var3);

        public void CredFree(Pointer var1);
    }

    static class Advapi32LibManager {
        private static Advapi32Lib INSTANCE = null;

        Advapi32LibManager() {
        }

        public static Advapi32Lib getInstance() {
            if (INSTANCE == null) {
                INSTANCE = ResourceHolder.INSTANCE;
            }
            return INSTANCE;
        }

        public static void setInstance(Advapi32Lib instance) {
            INSTANCE = instance;
        }

        public static void resetInstance() {
            if (Constants.getOS() == Constants.OS.WINDOWS) {
                INSTANCE = ResourceHolder.INSTANCE;
            }
        }

        private static class ResourceHolder {
            private static final Advapi32Lib INSTANCE = (Advapi32Lib)Native.loadLibrary((String)"advapi32", Advapi32Lib.class, (Map)W32APIOptions.UNICODE_OPTIONS);

            private ResourceHolder() {
            }
        }
    }

    static enum SecureStorageWindowsCredentialPersistType {
        CRED_PERSIST_NONE(0),
        CRED_PERSIST_SESSION(1),
        CRED_PERSIST_LOCAL_MACHINE(2),
        CRED_PERSIST_ENTERPRISE(3);

        private int type;
        private static Map<Integer, SecureStorageWindowsCredentialPersistType> map;

        private SecureStorageWindowsCredentialPersistType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        static {
            map = new HashMap<Integer, SecureStorageWindowsCredentialPersistType>();
            for (SecureStorageWindowsCredentialPersistType credPersistType : SecureStorageWindowsCredentialPersistType.values()) {
                map.put(credPersistType.type, credPersistType);
            }
        }
    }

    static enum SecureStorageWindowsCredentialType {
        CRED_TYPE_GENERIC(1),
        CRED_TYPE_DOMAIN_PASSWORD(2),
        CRED_TYPE_DOMAIN_CERTIFICATE(3),
        CRED_TYPE_DOMAIN_VISIBLE_PASSWORD(4),
        CRED_TYPE_GENERIC_CERTIFICATE(5),
        CRED_TYPE_DOMAIN_EXTENDED(6),
        CRED_TYPE_MAXIMUM(7);

        private int type;
        private static Map<Integer, SecureStorageWindowsCredentialType> map;

        private SecureStorageWindowsCredentialType(int type) {
            this.type = type;
        }

        public static SecureStorageWindowsCredentialType typeOf(int type) {
            return map.get(type);
        }

        public int getType() {
            return this.type;
        }

        static {
            map = new HashMap<Integer, SecureStorageWindowsCredentialType>();
            for (SecureStorageWindowsCredentialType credType : SecureStorageWindowsCredentialType.values()) {
                map.put(credType.type, credType);
            }
        }
    }

    public static class SecureStorageWindowsCredential
    extends Structure {
        public int Flags;
        public int Type;
        public WString TargetName;
        public WString Comment;
        public WinBase.FILETIME LastWritten = new WinBase.FILETIME();
        public int CredentialBlobSize;
        public Pointer CredentialBlob;
        public int Persist;
        public int AttributeCount;
        public Pointer Attributes;
        public WString TargetAlias;
        public WString UserName;

        protected List<String> getFieldOrder() {
            return Arrays.asList("Flags", "Type", "TargetName", "Comment", "LastWritten", "CredentialBlobSize", "CredentialBlob", "Persist", "AttributeCount", "Attributes", "TargetAlias", "UserName");
        }

        public SecureStorageWindowsCredential() {
        }

        public SecureStorageWindowsCredential(Pointer p) {
            super(p);
            this.read();
        }
    }
}

