/*
 * Decompiled with CFR 0.152.
 */
package hughai.controllers.level2;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.EnemySelector2;
import hughai.EnemyTracker;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.TerrainPos;
import hughai.packcoordinators.AttackPackCoordinator;
import hughai.packcoordinators.GuardPackCoordinator;
import hughai.packcoordinators.MoveToPackCoordinator;
import hughai.packcoordinators.PackCoordinatorSelector;
import hughai.packcoordinators.SpreadSearchPackCoordinatorWithSearchGrid;
import hughai.unitdata.BuildTable;
import hughai.unitdata.UnitController;
import hughai.utils.Config;
import hughai.utils.LogFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class TankController {
    public int MinTanksForAttack = 5;
    public int MinTanksForSpreadSearch = 50;
    HashSet<Unit> unitsToControl = new HashSet();
    UnitDef typicalunitdef;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    PlayerObjects playerObjects;
    UnitController unitcontroller;
    EnemyTracker enemyTracker;
    EnemySelector2 enemyselector;
    BuildTable buildtable;
    AttackPackCoordinator attackpackcoordinator;
    GuardPackCoordinator guardpackcoordinator;
    SpreadSearchPackCoordinatorWithSearchGrid spreadsearchpackcoordinator;
    MoveToPackCoordinator movetopackcoordinator;
    PackCoordinatorSelector packcoordinatorselector;
    Config config;
    TerrainPos LastAttackPos = null;
    Random random = new Random();
    boolean Active = false;

    public TankController(PlayerObjects playerObjects, UnitDef unitDef) {
        this.playerObjects = playerObjects;
        this.config = playerObjects.getConfig();
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.enemyTracker = playerObjects.getEnemyTracker();
        this.unitcontroller = playerObjects.getUnitController();
        this.typicalunitdef = unitDef;
        this.enemyselector = new EnemySelector2(playerObjects, unitDef.getSpeed() * 2.0f, unitDef);
        this.attackpackcoordinator = new AttackPackCoordinator(playerObjects);
        this.spreadsearchpackcoordinator = new SpreadSearchPackCoordinatorWithSearchGrid(playerObjects);
        this.movetopackcoordinator = new MoveToPackCoordinator(playerObjects);
        this.guardpackcoordinator = new GuardPackCoordinator(playerObjects);
        this.packcoordinatorselector = new PackCoordinatorSelector(playerObjects);
        this.packcoordinatorselector.LoadCoordinator(this.attackpackcoordinator);
        this.packcoordinatorselector.LoadCoordinator(this.spreadsearchpackcoordinator);
        this.packcoordinatorselector.LoadCoordinator(this.movetopackcoordinator);
        this.packcoordinatorselector.LoadCoordinator(this.guardpackcoordinator);
        this.logfile.WriteLine("*TankController Initialized*");
    }

    public void Activate() {
        if (!this.Active) {
            this.enemyTracker.registerListener(new EnemyTrackerHandler());
            this.csai.registerGameListener(new GameListenerHandler());
            if (this.csai.DebugOn) {
                this.csai.RegisterVoiceCommand("tankscount", new VoiceCommandCountTanks());
                this.csai.RegisterVoiceCommand("tanksmoveto", new VoiceCommandMoveTo());
                this.csai.RegisterVoiceCommand("dumptanks", new VoiceCommandDumpTanksHandler());
            }
            this.Active = true;
        }
    }

    public void Disactivate() {
        if (this.Active) {
            this.enemyTracker.unregisterGameListener(new EnemyTrackerHandler());
            this.csai.unregisterGameListener(new GameListenerHandler());
            this.csai.UnregisterVoiceCommand("tankscount");
            this.csai.UnregisterVoiceCommand("tanksmoveto");
            this.csai.UnregisterVoiceCommand("tanksattackpos");
            this.packcoordinatorselector.DisactivateAll();
            this.Active = false;
        }
    }

    public void AssignUnits(Collection<Unit> collection) {
        for (Unit unit : collection) {
            this.unitsToControl.add(unit);
            this.logfile.WriteLine("New tankcontroller unit: " + unit.getUnitId() + " " + unit.getDef().getHumanName());
            this.attackpackcoordinator.AssignUnits(collection);
            this.spreadsearchpackcoordinator.AssignUnits(collection);
            this.movetopackcoordinator.AssignUnits(collection);
            this.guardpackcoordinator.AssignUnits(collection);
        }
    }

    public void RevokeUnits(Collection<Unit> collection) {
        for (Unit unit : collection) {
            this.unitsToControl.remove(unit);
            this.attackpackcoordinator.RevokeUnits(collection);
            this.spreadsearchpackcoordinator.RevokeUnits(collection);
            this.movetopackcoordinator.RevokeUnits(collection);
            this.guardpackcoordinator.RevokeUnits(collection);
        }
    }

    public void AssignEnergy(int n) {
    }

    public void AssignMetal(int n) {
    }

    public void AssignPower(double d) {
    }

    public void AssignMetalStream(double d) {
    }

    void DoSomething() {
        List<Unit> list;
        String string = this.playerObjects.getBuildTree().listToOurTeamsUnitName(this.config.getCommanderunitnames());
        if (this.unitsToControl.size() >= this.MinTanksForAttack) {
            TerrainPos terrainPos = this.LastAttackPos;
            if (terrainPos == null) {
                for (Unit unit : this.unitsToControl) {
                    TerrainPos terrainPos2 = this.unitcontroller.getPos(unit);
                    if (terrainPos2 == null) continue;
                    terrainPos = terrainPos2;
                }
            }
            this.logfile.WriteLine("tankcontroller approximateattackpos: " + terrainPos);
            TerrainPos terrainPos3 = this.enemyselector.ChooseAttackPoint(terrainPos);
            if (terrainPos3 != null) {
                this.logfile.WriteLine("tankcontroller found enemy, attacking: " + terrainPos3);
                this.attackpackcoordinator.SetTarget(terrainPos3);
                this.packcoordinatorselector.ActivatePackCoordinator(this.attackpackcoordinator);
                this.LastAttackPos = terrainPos3;
            } else if (this.unitsToControl.size() > this.MinTanksForSpreadSearch) {
                this.spreadsearchpackcoordinator.SetTarget(terrainPos3);
                this.packcoordinatorselector.ActivatePackCoordinator(this.spreadsearchpackcoordinator);
            } else if (this.unitcontroller.UnitsByName.containsKey(string)) {
                this.guardpackcoordinator.SetTarget(this.unitcontroller.UnitsByName.get(string).get(0));
                this.packcoordinatorselector.ActivatePackCoordinator(this.guardpackcoordinator);
            }
        } else if (this.unitcontroller.UnitsByName.containsKey(string) && (list = this.unitcontroller.UnitsByName.get(string)).size() > 0) {
            this.guardpackcoordinator.SetTarget(list.get(0));
            this.packcoordinatorselector.ActivatePackCoordinator(this.guardpackcoordinator);
        }
    }

    class EnemyTrackerHandler
    extends EnemyTracker.EnemyAdapter {
        EnemyTrackerHandler() {
        }

        @Override
        public void AcquiredEnemy(Unit unit) {
        }

        @Override
        public void EnemyDestroyed(Unit unit) {
        }
    }

    class UnitControllerHandler
    extends UnitController.UnitAdapter {
        UnitControllerHandler() {
        }

        @Override
        public void UnitAdded(Unit unit) {
        }

        @Override
        public void UnitRemoved(Unit unit) {
        }
    }

    class GameListenerHandler
    extends GameAdapter {
        GameListenerHandler() {
        }

        @Override
        public void Tick(int n) {
            TankController.this.DoSomething();
        }

        @Override
        public void UnitIdle(Unit unit) {
        }
    }

    class VoiceCommandMoveTo
    implements VoiceCommandHandler {
        VoiceCommandMoveTo() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            TerrainPos terrainPos = new TerrainPos();
            terrainPos.x = Float.parseFloat(stringArray[2]);
            terrainPos.z = Float.parseFloat(stringArray[3]);
            terrainPos.y = TankController.this.playerObjects.getMaps().getHeightMap().getElevationAt(terrainPos);
            TankController.this.movetopackcoordinator.SetTarget(terrainPos);
            TankController.this.packcoordinatorselector.ActivatePackCoordinator(TankController.this.movetopackcoordinator);
        }
    }

    class VoiceCommandCountTanks
    implements VoiceCommandHandler {
        VoiceCommandCountTanks() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            TankController.this.csai.SendTextMsg("Number tanks: " + TankController.this.unitsToControl.size());
            TankController.this.logfile.WriteLine("Number tanks: " + TankController.this.unitsToControl.size());
        }
    }

    class VoiceCommandDumpTanksHandler
    implements VoiceCommandHandler {
        VoiceCommandDumpTanksHandler() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            TankController.this.logfile.WriteLine("Tankcontroller dump:");
            for (Unit unit : TankController.this.unitsToControl) {
                TankController.this.logfile.WriteLine(unit.getUnitId() + " " + unit.getDef().getHumanName());
            }
        }
    }
}

