/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ListELResolver
extends ELResolver {
    private final boolean readOnly;
    private static final Class<?> UNMODIFIABLE = Collections.unmodifiableList(new ArrayList()).getClass();

    public ListELResolver() {
        this.readOnly = false;
    }

    public ListELResolver(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object instanceof List) {
            eLContext.setPropertyResolved(object, object2);
            List list = (List)object;
            int n = ListELResolver.coerce(object2);
            if (n < 0 || n >= list.size()) {
                throw new PropertyNotFoundException(new ArrayIndexOutOfBoundsException(n).getMessage());
            }
            if (list.getClass() == UNMODIFIABLE || this.readOnly) {
                return null;
            }
            return Object.class;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object instanceof List) {
            eLContext.setPropertyResolved(object, object2);
            List list = (List)object;
            int n = ListELResolver.coerce(object2);
            if (n < 0 || n >= list.size()) {
                return null;
            }
            return list.get(n);
        }
        return null;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        Objects.requireNonNull(eLContext);
        if (object instanceof List) {
            eLContext.setPropertyResolved(object, object2);
            List list = (List)object;
            if (this.readOnly) {
                throw new PropertyNotWritableException(Util.message(eLContext, "resolverNotWritable", object.getClass().getName()));
            }
            int n = ListELResolver.coerce(object2);
            try {
                list.set(n, object3);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new PropertyNotWritableException(unsupportedOperationException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new PropertyNotFoundException(indexOutOfBoundsException);
            }
        }
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object instanceof List) {
            eLContext.setPropertyResolved(object, object2);
            List list = (List)object;
            try {
                int n = ListELResolver.coerce(object2);
                if (n < 0 || n >= list.size()) {
                    throw new PropertyNotFoundException(new ArrayIndexOutOfBoundsException(n).getMessage());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return this.readOnly || UNMODIFIABLE.equals(list.getClass());
        }
        return this.readOnly;
    }

    @Override
    @Deprecated(forRemoval=true, since="EL 5.0")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object instanceof List) {
            return Integer.class;
        }
        return null;
    }

    private static int coerce(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new IllegalArgumentException(object != null ? object.toString() : "null");
    }
}

