/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.util.net.openssl.OpenSSLX509Certificate;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLCertificateVerifier
implements CertificateVerifier {
    private static final Log log = LogFactory.getLog(OpenSSLCertificateVerifier.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLCertificateVerifier.class);
    private final X509TrustManager x509TrustManager;

    public OpenSSLCertificateVerifier(X509TrustManager x509TrustManager) {
        this.x509TrustManager = x509TrustManager;
    }

    public boolean verify(long l, byte[][] byArray, String string) {
        X509Certificate[] x509CertificateArray = OpenSSLCertificateVerifier.certificates(byArray);
        try {
            this.x509TrustManager.checkClientTrusted(x509CertificateArray, string);
            return true;
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("openssl.certificateVerificationFailed"), (Throwable)exception);
            }
            return false;
        }
    }

    private static X509Certificate[] certificates(byte[][] byArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = new OpenSSLX509Certificate(byArray[i]);
        }
        return x509CertificateArray;
    }
}

