/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.query;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.filters.FilterUIModel;
import org.gephi.desktop.filters.query.ParameterNode;
import org.gephi.desktop.filters.query.QueryChildren;
import org.gephi.desktop.filters.query.QueryNode;
import org.gephi.desktop.filters.query.RootNode;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.Query;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class QueryExplorer
extends BeanTreeView
implements PropertyChangeListener,
ChangeListener {
    private ExplorerManager manager;
    private FilterModel model;
    private FilterUIModel uiModel;
    private FilterController filterController;
    private boolean listenSelectedNodes = false;

    public QueryExplorer() {
        this.setSelectionMode(1);
    }

    public void unsetup() {
        if (this.model != null) {
            this.model.removeChangeListener((ChangeListener)this);
            this.model = null;
        }
    }

    public void setup(final ExplorerManager manager, final FilterModel model, FilterUIModel uiModel) {
        this.manager = manager;
        this.model = model;
        this.uiModel = uiModel;
        this.filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
        if (model != null) {
            model.addChangeListener((ChangeListener)this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    manager.setRootContext((Node)new RootNode((Children)new QueryChildren(model.getQueries())));
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    manager.setRootContext((Node)new AbstractNode(Children.LEAF){

                        public Action[] getActions(boolean context) {
                            return new Action[0];
                        }
                    });
                }
            });
        }
        this.updateEnabled(model != null);
        if (!this.listenSelectedNodes) {
            manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.listenSelectedNodes = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("selectedNodes")) {
            if (this.uiModel == null) {
                return;
            }
            Node[] nodeArray = (Node[])evt.getNewValue();
            if (nodeArray.length > 0) {
                Node node = ((Node[])evt.getNewValue())[0];
                if (node instanceof RootNode) {
                    this.uiModel.setSelectedQuery(null);
                    this.filterController.setCurrentQuery(null);
                    return;
                }
                while (!(node instanceof QueryNode)) {
                    if ((node = node.getParentNode()).getParentNode() != null) continue;
                    this.uiModel.setSelectedQuery(null);
                    this.filterController.setCurrentQuery(null);
                    return;
                }
                QueryNode queryNode = (QueryNode)node;
                final Query query = queryNode.getQuery();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        QueryExplorer.this.uiModel.setSelectedQuery(query);
                        QueryExplorer.this.model.removeChangeListener((ChangeListener)QueryExplorer.this);
                        QueryExplorer.this.filterController.setCurrentQuery(QueryExplorer.this.uiModel.getSelectedRoot());
                        QueryExplorer.this.model.addChangeListener((ChangeListener)QueryExplorer.this);
                    }
                }).start();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryExplorer.this.saveExpandStatus(QueryExplorer.this.manager.getRootContext());
                QueryExplorer.this.manager.setRootContext((Node)new RootNode((Children)new QueryChildren(QueryExplorer.this.model.getQueries())));
                QueryExplorer.this.loadExpandStatus(QueryExplorer.this.manager.getRootContext());
            }
        });
    }

    private void updateEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryExplorer.this.setRootVisible(enabled);
                QueryExplorer.this.setEnabled(enabled);
            }
        });
    }

    private void loadExpandStatus(Node node) {
        block5: {
            Node firstChild;
            block4: {
                if (!(node instanceof RootNode)) break block4;
                RootNode rootNode = (RootNode)node;
                for (Node n : rootNode.getChildren().getNodes()) {
                    this.loadExpandStatus(n);
                }
                break block5;
            }
            if (!(node instanceof QueryNode)) break block5;
            QueryNode queryNode = (QueryNode)node;
            if (this.uiModel.isExpanded(queryNode.getQuery())) {
                this.expandNode((Node)queryNode);
            }
            if ((firstChild = queryNode.getChildren().getNodeAt(0)) != null && firstChild instanceof ParameterNode && this.uiModel.isParametersExpanded(queryNode.getQuery())) {
                this.expandNode(firstChild);
            }
            for (Node n : queryNode.getChildren().getNodes()) {
                this.loadExpandStatus(n);
            }
        }
    }

    private void saveExpandStatus(Node node) {
        block4: {
            block3: {
                if (!(node instanceof RootNode)) break block3;
                RootNode rootNode = (RootNode)node;
                for (Node n : rootNode.getChildren().getNodes()) {
                    this.saveExpandStatus(n);
                }
                break block4;
            }
            if (!(node instanceof QueryNode)) break block4;
            QueryNode queryNode = (QueryNode)node;
            Node firstChild = queryNode.getChildren().getNodeAt(0);
            boolean parameterExpanded = false;
            if (firstChild != null && firstChild instanceof ParameterNode) {
                parameterExpanded = this.isExpanded(firstChild);
            }
            this.uiModel.setExpand(queryNode.getQuery(), this.isExpanded((Node)queryNode), parameterExpanded);
            for (Node n : queryNode.getChildren().getNodes()) {
                this.saveExpandStatus(n);
            }
        }
    }
}

