/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.validation.api.InvalidInputException;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.localization.LocalizationSupport;

public final class Problems
implements Iterable<Problem> {
    private final List<Problem> problems = new ArrayList<Problem>();
    private boolean hasFatal;

    @Deprecated
    public final void add(String problem) {
        this.add(problem, Severity.FATAL);
    }

    @Deprecated
    public final void add(String problem, Severity severity) {
        this.problems.add(new Problem(problem, severity));
        this.hasFatal |= severity == Severity.FATAL;
    }

    @Deprecated
    public final void add(Problem problem) {
        if (problem == null) {
            return;
        }
        this.problems.add(problem);
        this.hasFatal |= problem.severity() == Severity.FATAL;
    }

    public final Problems append(String problem) {
        this.add(problem);
        return this;
    }

    public final Problems append(String problem, Severity severity) {
        this.add(problem, severity);
        return this;
    }

    public final Problems append(Problem problem) {
        this.add(problem);
        return this;
    }

    public final Problems addAll(Problems problems) {
        this.putAll(problems);
        return this;
    }

    @Deprecated
    public final void putAll(Problems problems) {
        if (problems == this) {
            throw new IllegalArgumentException("putAll to self");
        }
        this.problems.addAll(problems.problems);
        this.hasFatal |= problems.hasFatal();
    }

    public final boolean hasFatal() {
        return this.hasFatal;
    }

    public static Problems create(String message) {
        assert (message != null);
        Problems result = new Problems();
        result.add(message);
        return result;
    }

    public static Problems create(Class<?> localizerClass, String bundleKey) {
        assert (bundleKey != null);
        assert (localizerClass != null);
        return Problems.create(LocalizationSupport.getMessage(localizerClass, bundleKey, new Object[0]));
    }

    public final Problem getLeadProblem() {
        Collections.sort(this.problems);
        return this.problems.isEmpty() ? null : this.problems.get(0);
    }

    public final List<? extends Problem> allProblems() {
        ArrayList<Problem> result = new ArrayList<Problem>(this.problems);
        Collections.sort(result);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Problem p : this.problems) {
            if (sb.length() == 0) {
                sb.append(p);
                continue;
            }
            sb = new StringBuilder(LocalizationSupport.getMessage(Problems.class, "CONCAT_PROBLEMS", sb, p));
        }
        return sb.toString();
    }

    public void throwIfFatalPresent(String msg) {
        if (this.hasFatal()) {
            throw new InvalidInputException(msg, this);
        }
    }

    public void throwIfFatalPresent() {
        if (this.hasFatal()) {
            throw new InvalidInputException(this);
        }
    }

    @Override
    public Iterator<Problem> iterator() {
        return Collections.unmodifiableCollection(this.problems).iterator();
    }
}

