/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.TestResult;
import org.testng.internal.invokers.ITestInvoker;
import org.testng.internal.invokers.TestMethodArguments;
import org.testng.xml.XmlSuite;

public class TestMethodWithDataProviderMethodWorker
implements Callable<List<ITestResult>>,
Comparable<TestMethodWithDataProviderMethodWorker> {
    private final ITestNGMethod m_testMethod;
    private final Object[] m_parameterValues;
    private final Object m_instance;
    private final Map<String, String> m_parameters;
    private final ITestClass m_testClass;
    private final ITestNGMethod[] m_beforeMethods;
    private final ITestNGMethod[] m_afterMethods;
    private final ConfigurationGroupMethods m_groupMethods;
    private final ITestContext m_testContext;
    private int m_parameterIndex;
    private boolean m_skipFailedInvocationCounts;
    private int m_invocationCount;
    private final ITestResultNotifier m_notifier;
    private final ITestInvoker m_testInvoker;
    private final List<ITestResult> m_testResults = Lists.newArrayList();
    private int m_failureCount;

    public TestMethodWithDataProviderMethodWorker(ITestInvoker testInvoker, ITestNGMethod testMethod, int parameterIndex, Object[] parameterValues, Object instance, Map<String, String> parameters, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, ITestContext testContext, boolean skipFailedInvocationCounts, int invocationCount, int failureCount, ITestResultNotifier notifier) {
        this.m_testInvoker = testInvoker;
        this.m_testMethod = testMethod;
        this.m_parameterIndex = parameterIndex;
        this.m_parameterValues = parameterValues;
        this.m_instance = instance;
        this.m_parameters = parameters;
        this.m_testClass = testClass;
        this.m_beforeMethods = beforeMethods;
        this.m_afterMethods = afterMethods;
        this.m_groupMethods = groupMethods;
        this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        this.m_testContext = testContext;
        this.m_invocationCount = invocationCount;
        this.m_failureCount = failureCount;
        this.m_notifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITestResult> call() {
        long start;
        block13: {
            ITestInvoker.FailureContext failure;
            block12: {
                List tmpResults = Lists.newArrayList();
                start = System.currentTimeMillis();
                XmlSuite suite = this.m_testContext.getSuite().getXmlSuite();
                failure = new ITestInvoker.FailureContext();
                failure.count.set(this.m_failureCount);
                try {
                    tmpResults.add(this.m_testInvoker.invokeTestMethod(new TestMethodArguments.Builder().usingInstance(this.m_instance).forTestMethod(this.m_testMethod).withParameterValues(this.m_parameterValues).withParametersIndex(this.m_parameterIndex).withParameters(this.m_parameters).forTestClass(this.m_testClass).usingBeforeMethods(this.m_beforeMethods).usingAfterMethods(this.m_afterMethods).usingGroupMethods(this.m_groupMethods).build(), suite, failure));
                    this.m_failureCount = failure.count.get();
                    if (!failure.instances.isEmpty()) break block12;
                    this.m_testResults.addAll(tmpResults);
                }
                catch (Throwable throwable) {
                    this.m_failureCount = failure.count.get();
                    if (failure.instances.isEmpty()) {
                        this.m_testResults.addAll(tmpResults);
                    } else {
                        for (Object instance : failure.instances) {
                            List<ITestResult> retryResults = Lists.newArrayList();
                            this.m_failureCount = this.m_testInvoker.retryFailed((TestMethodArguments)new TestMethodArguments.Builder().usingInstance((Object)instance).forTestMethod((ITestNGMethod)this.m_testMethod).withParameterValues((Object[])this.m_parameterValues).withParametersIndex((int)this.m_parameterIndex).withParameters(this.m_parameters).forTestClass((ITestClass)this.m_testClass).usingBeforeMethods((ITestNGMethod[])this.m_beforeMethods).usingAfterMethods((ITestNGMethod[])this.m_afterMethods).usingGroupMethods((ConfigurationGroupMethods)this.m_groupMethods).build(), retryResults, (int)this.m_failureCount, (ITestContext)this.m_testContext).count.get();
                            this.m_testResults.addAll(retryResults);
                        }
                    }
                    if (!this.m_skipFailedInvocationCounts) {
                        this.m_skipFailedInvocationCounts = this.m_testMethod.skipFailedInvocations();
                    }
                    if (this.m_failureCount > 0 && this.m_skipFailedInvocationCounts) {
                        while (this.m_invocationCount-- > 0) {
                            TestResult r = TestResult.newEndTimeAwareTestResult(this.m_testMethod, this.m_testContext, null, start);
                            r.setStatus(3);
                            this.m_testResults.add(r);
                            this.m_testInvoker.runTestResultListener(r);
                            this.m_notifier.addSkippedTest(this.m_testMethod, r);
                        }
                    }
                    throw throwable;
                }
                break block13;
            }
            for (Object instance : failure.instances) {
                List<ITestResult> retryResults = Lists.newArrayList();
                this.m_failureCount = this.m_testInvoker.retryFailed((TestMethodArguments)new TestMethodArguments.Builder().usingInstance((Object)instance).forTestMethod((ITestNGMethod)this.m_testMethod).withParameterValues((Object[])this.m_parameterValues).withParametersIndex((int)this.m_parameterIndex).withParameters(this.m_parameters).forTestClass((ITestClass)this.m_testClass).usingBeforeMethods((ITestNGMethod[])this.m_beforeMethods).usingAfterMethods((ITestNGMethod[])this.m_afterMethods).usingGroupMethods((ConfigurationGroupMethods)this.m_groupMethods).build(), retryResults, (int)this.m_failureCount, (ITestContext)this.m_testContext).count.get();
                this.m_testResults.addAll(retryResults);
            }
        }
        if (!this.m_skipFailedInvocationCounts) {
            this.m_skipFailedInvocationCounts = this.m_testMethod.skipFailedInvocations();
        }
        if (this.m_failureCount > 0 && this.m_skipFailedInvocationCounts) {
            while (this.m_invocationCount-- > 0) {
                TestResult r = TestResult.newEndTimeAwareTestResult(this.m_testMethod, this.m_testContext, null, start);
                r.setStatus(3);
                this.m_testResults.add(r);
                this.m_testInvoker.runTestResultListener(r);
                this.m_notifier.addSkippedTest(this.m_testMethod, r);
            }
        }
        ++this.m_parameterIndex;
        return this.m_testResults;
    }

    public int getInvocationCount() {
        return this.m_invocationCount;
    }

    @Override
    public int compareTo(TestMethodWithDataProviderMethodWorker o) {
        return Integer.compare(this.m_testMethod.getPriority(), o.m_testMethod.getPriority());
    }
}

