/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyNameError;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Define;
import org.jruby.exceptions.NoMethodError;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"NoMethodError"}, parent="NameError")
public class RubyNoMethodError
extends RubyNameError {
    private IRubyObject args;
    private static final ObjectAllocator ALLOCATOR = RubyNoMethodError::new;

    static RubyClass define(ThreadContext context, RubyClass NameError2) {
        return (RubyClass)Define.defineClass(context, "NoMethodError", NameError2, ALLOCATOR).defineMethods(context, RubyNoMethodError.class);
    }

    protected RubyNoMethodError(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass, exceptionClass.getName(runtime2.getCurrentContext()));
        this.args = runtime2.getNil();
    }

    public RubyNoMethodError(Ruby runtime2, RubyClass exceptionClass, String message2, String name2, IRubyObject args2) {
        super(runtime2, exceptionClass, message2, name2);
        this.args = args2;
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new NoMethodError(message2, this);
    }

    public static RubyException newNoMethodError(IRubyObject recv2, IRubyObject message2, IRubyObject name2, IRubyObject args2) {
        ThreadContext context = recv2.getRuntime().getCurrentContext();
        RubyClass klass = (RubyClass)recv2;
        RubyException newError = (RubyException)klass.allocate(context);
        newError.callInit(message2, name2, args2, Block.NULL_BLOCK);
        return newError;
    }

    public static RubyException newNoMethodError(IRubyObject recv2, IRubyObject message2, IRubyObject name2, IRubyObject args2, boolean privateCall) {
        ThreadContext context = recv2.getRuntime().getCurrentContext();
        RubyClass klass = (RubyClass)recv2;
        RubyNoMethodError newError = (RubyNoMethodError)klass.allocate(context);
        newError.callInit(message2, name2, args2, Block.NULL_BLOCK);
        newError.privateCall = privateCall;
        return newError;
    }

    @Override
    public IRubyObject initializeOptions(IRubyObject[] args2, RubyHash options2, Block block) {
        int argc = args2.length;
        if (argc > 3) {
            this.privateCall = args2[--argc].isTrue() && !args2[argc].isNil();
        }
        this.args = argc > 2 ? args2[--argc] : this.getRuntime().getNil();
        super.initializeOptions(args2, options2, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject args() {
        return this.args;
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        super.copySpecialInstanceVariables(clone2);
        RubyNoMethodError exception2 = (RubyNoMethodError)clone2;
        exception2.args = this.args;
    }
}

