/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.TreatableDomainType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatableDomainType;
import org.hibernate.query.sqm.tree.from.SqmTreatedAttributeJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedSetJoin<O, T, S extends T>
extends SqmSetJoin<O, S>
implements SqmTreatedAttributeJoin<O, T, S> {
    private final SqmSetJoin<O, T> wrappedPath;
    private final SqmTreatableDomainType<S> treatTarget;

    public SqmTreatedSetJoin(SqmSetJoin<O, T> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias) {
        this(wrappedPath, treatTarget, alias, false);
    }

    public SqmTreatedSetJoin(SqmSetJoin<O, T> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()).treatAs(treatTarget.getTypeName(), alias), wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedSetJoin(NavigablePath navigablePath, SqmSetJoin<O, T> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), navigablePath, wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedSetJoin<O, T, S> copy(SqmCopyContext context) {
        SqmTreatedSetJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedSetJoin<O, T, S> path = context.registerCopy(this, new SqmTreatedSetJoin<O, T, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias(), this.isFetched()));
        this.copyTo(path, context);
        return path;
    }

    public SqmSetJoin<O, T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public TreatableDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmBindableType<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public SqmTreatableDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("treat(");
        this.wrappedPath.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.treatTarget.getTypeName());
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmTreatedSetJoin)) return false;
        SqmTreatedSetJoin that = (SqmTreatedSetJoin)object;
        if (!Objects.equals(this.getExplicitAlias(), that.getExplicitAlias())) return false;
        if (!Objects.equals(this.treatTarget.getTypeName(), that.treatTarget.getTypeName())) return false;
        if (!Objects.equals(this.wrappedPath.getNavigablePath(), that.wrappedPath.getNavigablePath())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.treatTarget.getTypeName(), this.wrappedPath.getNavigablePath());
    }

    @Override
    public SqmTreatedSetJoin<O, T, S> on(JpaExpression<Boolean> restriction) {
        return (SqmTreatedSetJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmTreatedSetJoin<O, T, S> on(Expression<Boolean> restriction) {
        return (SqmTreatedSetJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmTreatedSetJoin<O, T, S> on(JpaPredicate ... restrictions) {
        return (SqmTreatedSetJoin)super.on(restrictions);
    }

    @Override
    public SqmTreatedSetJoin<O, T, S> on(Predicate ... restrictions) {
        return (SqmTreatedSetJoin)super.on(restrictions);
    }
}

