/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.auth;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public final class AuthSchemePreferenceResolver {
    private final Supplier<ProfileFile> profileFile;
    private final String profileName;

    private AuthSchemePreferenceResolver(Builder builder) {
        this.profileFile = (Supplier)Validate.getOrDefault((Object)builder.profileFile, () -> ProfileFile::defaultProfileFile);
        this.profileName = (String)Validate.getOrDefault((Object)builder.profileName, () -> ((ProfileFileSystemSetting)ProfileFileSystemSetting.AWS_PROFILE).getStringValueOrThrow());
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> resolveAuthSchemePreference() {
        List<String> systemSettingList = this.fromSystemSetting();
        if (!CollectionUtils.isNullOrEmpty(systemSettingList)) {
            return systemSettingList;
        }
        List<String> profileFilePrefList = this.fromProfileFile();
        if (!CollectionUtils.isNullOrEmpty(profileFilePrefList)) {
            return profileFilePrefList;
        }
        return Collections.emptyList();
    }

    private List<String> fromSystemSetting() {
        Optional value = SdkSystemSetting.AWS_AUTH_SCHEME_PREFERENCE.getStringValue();
        if (value.isPresent()) {
            return AuthSchemePreferenceResolver.parseAuthSchemeList((String)value.get());
        }
        return Collections.emptyList();
    }

    private List<String> fromProfileFile() {
        ProfileFile profileFile = this.profileFile.get();
        Optional profile = profileFile.profile(this.profileName);
        String unformattedAuthSchemePreferenceList = profile.flatMap(p -> p.property("auth_scheme_preference")).orElse(null);
        return unformattedAuthSchemePreferenceList != null ? AuthSchemePreferenceResolver.parseAuthSchemeList(unformattedAuthSchemePreferenceList) : Collections.emptyList();
    }

    private static List<String> parseAuthSchemeList(String unformattedList) {
        if (StringUtils.isEmpty((CharSequence)unformattedList)) {
            return Collections.emptyList();
        }
        return Arrays.asList(unformattedList.replaceAll("\\s+", "").split(","));
    }

    public static final class Builder {
        private Supplier<ProfileFile> profileFile;
        private String profileName;

        public Builder profileFile(Supplier<ProfileFile> profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public AuthSchemePreferenceResolver build() {
            return new AuthSchemePreferenceResolver(this);
        }
    }
}

