/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN990Codec;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.DataAccessHint;
import org.apache.lucene.store.FileDataHint;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IOUtils;
import org.opensearch.common.UUIDs;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.codec.KNN990Codec.QuantizationConfigKNNCollector;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.codec.util.NativeMemoryCacheKeyHelper;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.quantizationservice.QuantizationService;
import org.opensearch.knn.memoryoptsearch.VectorSearcher;
import org.opensearch.knn.memoryoptsearch.VectorSearcherFactory;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationStateCacheManager;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationStateReadConfig;

public class NativeEngines990KnnVectorsReader
extends KnnVectorsReader {
    @Generated
    private static final Logger log = LogManager.getLogger(NativeEngines990KnnVectorsReader.class);
    private static final int RESERVE_TWICE_SPACE = 2;
    private static final float SUFFICIENT_LOAD_FACTOR = 0.6f;
    private final FlatVectorsReader flatVectorsReader;
    private Map<String, String> quantizationStateCacheKeyPerField;
    private final SegmentReadState segmentReadState;
    private final List<String> cacheKeys;
    private volatile Map<String, VectorSearcherHolder> vectorSearchers;
    private final IOContext ioContext;

    public NativeEngines990KnnVectorsReader(SegmentReadState state, FlatVectorsReader flatVectorsReader) {
        this.flatVectorsReader = flatVectorsReader;
        this.segmentReadState = state;
        this.cacheKeys = NativeEngines990KnnVectorsReader.getVectorCacheKeysFromSegmentReaderState(state);
        this.ioContext = state.context.withHints(new IOContext.FileOpenHint[]{FileTypeHint.DATA, FileDataHint.KNN_VECTORS, DataAccessHint.RANDOM});
        this.loadCacheKeyMap();
        this.fillVectorSearcherTable();
    }

    public void checkIntegrity() throws IOException {
        this.flatVectorsReader.checkIntegrity();
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.flatVectorsReader.getFloatVectorValues(field);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.flatVectorsReader.getByteVectorValues(field);
    }

    public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        if (knnCollector instanceof QuantizationConfigKNNCollector) {
            String cacheKey = this.quantizationStateCacheKeyPerField.get(field);
            FieldInfo fieldInfo = this.segmentReadState.fieldInfos.fieldInfo(field);
            QuantizationState quantizationState = QuantizationStateCacheManager.getInstance().getQuantizationState(new QuantizationStateReadConfig(this.segmentReadState, QuantizationService.getInstance().getQuantizationParams(fieldInfo, this.segmentReadState.segmentInfo.getVersion()), field, cacheKey));
            ((QuantizationConfigKNNCollector)knnCollector).setQuantizationState(quantizationState);
            return;
        }
        if (this.trySearchWithMemoryOptimizedSearch(field, target, knnCollector, acceptDocs, true)) {
            return;
        }
        throw new UnsupportedOperationException("Search functionality using codec is not supported with Native Engine Reader");
    }

    public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        if (this.trySearchWithMemoryOptimizedSearch(field, target, knnCollector, acceptDocs, false)) {
            return;
        }
        throw new UnsupportedOperationException("Search functionality using codec is not supported with Native Engine Reader");
    }

    public void close() throws IOException {
        NativeMemoryCacheManager nativeMemoryCacheManager = NativeMemoryCacheManager.getInstance();
        this.cacheKeys.forEach(nativeMemoryCacheManager::invalidate);
        ArrayList<Object> closeables = new ArrayList<Object>();
        closeables.add(this.flatVectorsReader);
        if (this.vectorSearchers != null) {
            closeables.addAll(this.vectorSearchers.values().stream().filter(VectorSearcherHolder::isSet).map(VectorSearcherHolder::getVectorSearcher).toList());
        }
        IOUtils.close(closeables);
        if (this.quantizationStateCacheKeyPerField != null) {
            QuantizationStateCacheManager quantizationStateCacheManager = QuantizationStateCacheManager.getInstance();
            for (String cacheKey : this.quantizationStateCacheKeyPerField.values()) {
                quantizationStateCacheManager.evict(cacheKey);
            }
        }
    }

    private boolean trySearchWithMemoryOptimizedSearch(String field, Object target, KnnCollector knnCollector, AcceptDocs acceptDocs, boolean isFloatVector) throws IOException {
        VectorSearcher memoryOptimizedSearcher = this.loadMemoryOptimizedSearcherIfRequired(field);
        if (memoryOptimizedSearcher != null) {
            if (isFloatVector) {
                memoryOptimizedSearcher.search((float[])target, knnCollector, acceptDocs);
            } else {
                memoryOptimizedSearcher.search((byte[])target, knnCollector, acceptDocs);
            }
            return true;
        }
        return false;
    }

    private void loadCacheKeyMap() {
        this.quantizationStateCacheKeyPerField = new HashMap<String, String>();
        for (FieldInfo fieldInfo : this.segmentReadState.fieldInfos) {
            String cacheKey = UUIDs.base64UUID();
            this.quantizationStateCacheKeyPerField.put(fieldInfo.getName(), cacheKey);
        }
    }

    private void fillVectorSearcherTable() {
        this.vectorSearchers = new HashMap<String, VectorSearcherHolder>(2 * this.segmentReadState.fieldInfos.size(), 0.6f);
        for (FieldInfo fieldInfo : this.segmentReadState.fieldInfos) {
            IOSupplier<VectorSearcher> searcherIOSupplier = this.getVectorSearcherSupplier(fieldInfo);
            if (searcherIOSupplier == null) continue;
            this.vectorSearchers.put(fieldInfo.getName(), new VectorSearcherHolder());
        }
    }

    private static List<String> getVectorCacheKeysFromSegmentReaderState(SegmentReadState segmentReadState) {
        ArrayList<String> cacheKeys = new ArrayList<String>();
        for (FieldInfo field : segmentReadState.fieldInfos) {
            String vectorIndexFileName = KNNCodecUtil.getNativeEngineFileFromFieldInfo(field, segmentReadState.segmentInfo);
            if (vectorIndexFileName == null) continue;
            String cacheKey = NativeMemoryCacheKeyHelper.constructCacheKey(vectorIndexFileName, segmentReadState.segmentInfo);
            cacheKeys.add(cacheKey);
        }
        return cacheKeys;
    }

    private VectorSearcher loadMemoryOptimizedSearcherIfRequired(String fieldName) {
        VectorSearcherHolder searcherHolder = this.vectorSearchers.get(fieldName);
        if (searcherHolder == null) {
            return null;
        }
        if (searcherHolder.isSet()) {
            return searcherHolder.getVectorSearcher();
        }
        VectorSearcherHolder vectorSearcherHolder = searcherHolder;
        synchronized (vectorSearcherHolder) {
            if (searcherHolder.isSet()) {
                return searcherHolder.getVectorSearcher();
            }
            VectorSearcher searcher = null;
            try {
                IOSupplier<VectorSearcher> searcherSupplier;
                FieldInfo fieldInfo = this.segmentReadState.fieldInfos.fieldInfo(fieldName);
                if (fieldInfo != null && (searcherSupplier = this.getVectorSearcherSupplier(fieldInfo)) != null && (searcher = (VectorSearcher)searcherSupplier.get()) != null) {
                    searcherHolder.setVectorSearcher(searcher);
                }
                return searcher;
            }
            catch (Exception e) {
                try {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searcher});
                }
                catch (Exception closeException) {
                    log.error(closeException.getMessage(), (Throwable)closeException);
                }
                throw new RuntimeException(e);
            }
        }
    }

    private IOSupplier<VectorSearcher> getVectorSearcherSupplier(FieldInfo fieldInfo) {
        Map attributes = fieldInfo.attributes();
        if (attributes == null || !attributes.containsKey("knn_field")) {
            return null;
        }
        KNNEngine knnEngine = FieldInfoExtractor.extractKNNEngine(fieldInfo);
        if (knnEngine == null) {
            return null;
        }
        VectorSearcherFactory searcherFactory = knnEngine.getVectorSearcherFactory();
        if (searcherFactory == null) {
            return null;
        }
        String fileName = KNNCodecUtil.getNativeEngineFileFromFieldInfo(fieldInfo, this.segmentReadState.segmentInfo);
        if (fileName != null) {
            return () -> searcherFactory.createVectorSearcher(this.segmentReadState.directory, fileName, fieldInfo, this.ioContext);
        }
        return null;
    }

    public static class VectorSearcherHolder {
        private volatile VectorSearcher vectorSearcher = null;

        public void setVectorSearcher(@NonNull VectorSearcher vectorSearcher) {
            if (vectorSearcher == null) {
                throw new NullPointerException("vectorSearcher is marked non-null but is null");
            }
            assert (this.vectorSearcher == null);
            this.vectorSearcher = vectorSearcher;
        }

        public boolean isSet() {
            return this.vectorSearcher != null;
        }

        @Generated
        public VectorSearcher getVectorSearcher() {
            return this.vectorSearcher;
        }
    }
}

