\name{SignedMaurerDistanceMapImageFilter}
\alias{SignedMaurerDistanceMapImageFilter}
\title{SignedMaurerDistanceMapImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter calculates the Euclidean distance transform of a binary
image in linear time for arbitrary dimensions.
SignedMaurerDistanceMapImageFilter}
\details{
Inputs and Outputs
This is an image-to-image filter. The dimensionality is arbitrary. The
only dimensionality constraint is that the input and output images be
of the same dimensions and size. To maintain integer arithmetic within
the filter, the default output is the signed squared distance. This
implies that the input image should be of type "unsigned int" or
"int" whereas the output image is of type "int". Obviously, if the
user wishes to utilize the image spacing or to have a filter with the
Euclidean distance (as opposed to the squared distance), output image
types of float or double should be used.
 The inside is considered as having negative distances. Outside is
treated as having positive distances. To change the convention, use
the InsideIsPositive(bool) function.
Parameters
Set/GetBackgroundValue specifies the background of the value of the
input binary image. Normally this is zero and, as such, zero is the
default value. Other than that, the usage is completely analogous to
the itk::DanielssonDistanceImageFilter class except it does not return
the Voronoi map.
 Reference: C. R. Maurer, Jr., R. Qi, and V. Raghavan, "A Linear Time Algorithm for Computing Exact Euclidean Distance Transforms of Binary Images in
Arbitrary Dimensions", IEEE - Transactions on Pattern Analysis and
Machine Intelligence, 25(2): 265-270, 2003.
See:
SignedMaurerDistanceMap for the procedural interface
itk::SignedMaurerDistanceMapImageFilter for the Doxygen on the original ITK class.
SignedMaurerDistanceMapImageFilter}
%C++ includes: sitkSignedMaurerDistanceMapImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Set the background value which defines the object. Usually this value
is = 0.
}
\item{bool GetInsideIsPositive() const:}{
Get if the inside represents positive values in the signed distance
map.
See:
GetInsideIsPositive()
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetSquaredDistance() const:}{
Get the distance squared.
}
\item{bool GetUseImageSpacing() const:}{
Get whether spacing is used.
}
\item{Self InsideIsPositiveOff():}{}
\item{Self InsideIsPositiveOn():}{
Set the value of InsideIsPositive to true or false respectfully.
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set the background value which defines the object. Usually this value
is = 0.
}
\item{Self SetInsideIsPositive(bool InsideIsPositive):}{
Set if the inside represents positive values in the signed distance
map. By convention ON pixels are treated as inside pixels.
}
\item{Self SetSquaredDistance(bool SquaredDistance):}{
Set if the distance should be squared.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set if image spacing should be used in computing distances.
}
\item{ SignedMaurerDistanceMapImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SquaredDistanceOff():}{}
\item{Self SquaredDistanceOn():}{
Set the value of SquaredDistance to true or false respectfully.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~SignedMaurerDistanceMapImageFilter():}{
Destructor
}
}
}
