/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.geom.AffineTransform;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.util.Matrix;

public class PDShadingType1
extends PDShadingResources {
    private COSArray domain = null;

    public PDShadingType1(COSDictionary shadingDictionary) {
        super(shadingDictionary);
    }

    @Override
    public int getShadingType() {
        return 1;
    }

    public Matrix getMatrix() {
        Matrix retval = null;
        COSArray array = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            retval = new Matrix();
            retval.setValue(0, 0, ((COSNumber)array.get(0)).floatValue());
            retval.setValue(0, 1, ((COSNumber)array.get(1)).floatValue());
            retval.setValue(1, 0, ((COSNumber)array.get(2)).floatValue());
            retval.setValue(1, 1, ((COSNumber)array.get(3)).floatValue());
            retval.setValue(2, 0, ((COSNumber)array.get(4)).floatValue());
            retval.setValue(2, 1, ((COSNumber)array.get(5)).floatValue());
        }
        return retval;
    }

    public void setMatrix(AffineTransform transform) {
        COSArray matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            matrix.add(new COSFloat((float)v));
        }
        this.getCOSDictionary().setItem(COSName.MATRIX, (COSBase)matrix);
    }

    public COSArray getDomain() {
        if (this.domain == null) {
            this.domain = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.DOMAIN);
        }
        return this.domain;
    }

    public void setDomain(COSArray newDomain) {
        this.domain = newDomain;
        this.getCOSDictionary().setItem(COSName.DOMAIN, (COSBase)newDomain);
    }
}

