/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileCopier {
    public void copy(File in, File out) throws IOException {
        try {
            this.copyNIO(in, out);
        }
        catch (IOException e) {
            this.copyLegacy(in, out);
        }
    }

    public void copyLegacy(File in, File out) throws IOException {
        try (FileInputStream inStream = new FileInputStream(in);
             BufferedInputStream inBuf = new BufferedInputStream(inStream);
             FileOutputStream outStream = new FileOutputStream(out);
             BufferedOutputStream outBuf = new BufferedOutputStream(outStream);){
            byte[] buf = new byte[10240];
            int len = 1;
            while (len > 0) {
                len = inBuf.read(buf);
                if (len <= 0) continue;
                outBuf.write(buf, 0, len);
            }
        }
    }

    public void copyNIO(File in, File out) throws IOException {
        try (FileInputStream inStream = new FileInputStream(in);
             FileOutputStream outStream = new FileOutputStream(out);
             FileChannel sourceChannel = inStream.getChannel();
             FileChannel destinationChannel = outStream.getChannel();){
            destinationChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
    }
}

